!
         SUBROUTINE SEQTRA(VPM,VMM,VOM,VPP,VMP,VOP,                     &
     &     THETAA,VAM,VBM,VCM,VAP,VBP,VCP,VAT,VBT,VCT)
!
! SUBROUITINE FOR GENERATING PHASE QUANTITIES VA, VB, VC FROM
! SEQUENCE QUANTITIES VP, VM, VO; which are specified in magnitude
! and phase.
! WRITTEN 20 May 1997, by A.M. Gole, Univ. of Manitoba
!-------------------------------------------------------------
! INPUTS: 
!    VPm, VMm, VOm: +/-/0 sequence magnitudes(l-l, rms)
!    VPp, VMp, VOp: --"--- phases (degrees)
!    thetaa (deg):  angle for generating time domain waveforms.
!             i.e., thetaa=w*t (in deg) or could be derived from a reference
!             provided from a phase locked loop for obtaining a given bus 
!             voltage for a reference.
! OUTPUTS: 
!    VAm,VBm, VCm : Magnitudes of the phase voltages (useful in debugging)
!    VAp, VBp, VCp: Phase of       "   "     "        "  
!    VAT, VBT, VCT: Actual (time domain) phase voltages.
!+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
! PI_BY180 (Pi/180) and BY180_PI (180/Pi)
      INCLUDE 'emtconst.h'
!
!  ARGUMENT DEFINITIONS
!
!
      REAL VPM,VMM,VOM,VPP,VMP,VOP
      REAL  VAM,VBM,VCM,VAP,VBP,VCP,VAT,VBT,VCT
      REAL THETA,THETAA
      COMPLEX ALPH,ALPH2,VP,VM,VO,VA,VB,VC
!
      ALPH = 0.5*CMPLX(-1.0,SQRT(3.0))
      ALPH2 = 0.5*CMPLX(-1.0,-SQRT(3.0))
!
! Generating the complex values for the sequence voltages:
!
      VP=VPM*CMPLX(COS(VPP*PI_BY180),SIN(VPP*PI_BY180))
      VM=VMM*CMPLX(COS(VMP*PI_BY180),SIN(VMP*PI_BY180))
      VO=VOM*CMPLX(COS(VOP*PI_BY180),SIN(VOP*PI_BY180))
!
!  Generating the complex values for phase voltages:
!
      VA= VO+VP+VM
      VB= VO + ALPH2*VP + ALPH*VM
      VC= VO + ALPH*VP + ALPH2*VM
!
! Generating the magnitude and phase for each of the phase quantities:
!
      VAM = CABS(VA)
      VBM = CABS(VB)
      VCM = CABS(VC)
!
      IF(VAM.GE.1E-20) THEN
        VAP = ATAN2(AIMAG(VA), REAL(VA))
      ELSE
        VAP=0
      ENDIF
      IF(VBM.GE.1E-20) THEN
        VBP = ATAN2(AIMAG(VB), REAL(VB))
      ELSE
        VBP=0
      ENDIF
      IF(VCM.GE.1E-20) THEN
        VCP = ATAN2(AIMAG(VC), REAL(VC))
      ELSE
        VCP=0
      ENDIF
! Reconstructing the time domain waveforms:
!
      THETA =THETAA*PI_BY180
      VAT = 0.81649658*VAM*COS(VAP+THETA)
      VBT = 0.81649658*VBM*COS(VBP+THETA)
      VCT = 0.81649658*VCM*COS(VCP+THETA)
!
! Converting phase quantities to degrees for output:
!
      VAP=VAP*BY180_PI 
      VBP=VBP*BY180_PI 
      VCP=VCP*BY180_PI 
! 
      RETURN
      END

